#ifndef __CollectionTypedef__
#define __CollectionTypedef__


/**
 * @file CollectionTypedef.h
 * @brief Typedefs of Collections
 *
 * @date 23/01/2006
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: CollectionTypedef.h,v 1.4 2007/02/08 21:06:44 paul Exp $
 */

#include "TCountedPointerArray.hpp"
#include "../Basics/CString.hpp"

using Exponent::Basics::CString;

namespace Exponent
{
	namespace Collections
	{

		/** 
		 * @typedef TStringCountedPointerArray
		 * @brief Array of counted string pointers
		 */
		typedef TCountedPointerArray<CString> TStringCountedPointerArray;
	}
}

#endif		// End of CollectionTypedef.h